#include <iostream>
#include <vector>
#include <bits/stdc++.h>

using namespace std;

void napraviXorPrefikse(const vector<unsigned long long>& niz, vector<unsigned long long>& prefiksi) {
    unsigned long n = niz.size();
    prefiksi.resize(n);

    prefiksi[0] = niz[0];
    for (unsigned long i = 1; i < n; i++) {
        prefiksi[i] = prefiksi[i - 1] ^ niz[i];
    }
}
unsigned long long izracunajXorNaIntervalu(vector<unsigned long long>& prefiksi, unsigned long levo, unsigned long desno)
{
    return prefiksi[desno] ^ (levo > 0 ? prefiksi[levo - 1] : 0);
}

void napraviRetkuAndTabelu(const vector<unsigned long long>& niz, vector<vector<unsigned long long>>& tabela) {
    unsigned long n = niz.size();
    unsigned long maxLog = log2(n);
    tabela.resize(n, vector<unsigned long long>(maxLog + 1));

    for (unsigned long i = 0; i < n; i++) {
        tabela[i][0] = niz[i];
    }

    for (unsigned long k = 1; (1 << k) <= n; k++) {
        for (unsigned long i = 0; i + (1 << k) - 1 < n; i++) {
            tabela[i][k] = tabela[i][k - 1] & tabela[i + (1 << (k - 1))][k - 1];
        }
    }
}

unsigned long long izracunajAndNaIntervalu(const vector<vector<unsigned long long>>& tabela, unsigned long levo, unsigned long desno) {
    unsigned long k = log2(desno - levo + 1);
    return tabela[levo][k] & tabela[desno - (1 << k) + 1][k];
}

unsigned long long dvaNiza(const vector<unsigned long long>& a, const vector<unsigned long long>& b, unsigned long& levo, unsigned long& desno)
{
    vector<unsigned long long> xorPrefiksi;
    napraviXorPrefikse(a, xorPrefiksi);

    vector<vector<unsigned long long>> retkaAndTabela;
    napraviRetkuAndTabelu(b, retkaAndTabela);

    unsigned long n = a.size();
    unsigned long long max = 0;
    levo = desno = 0;
    for (unsigned long i = 0; i < n; i++)
    {
        for (unsigned long j = i; j < n; j++)
        {
            if (b[j] == 0)
            {
                break;
            }

            unsigned long long p = izracunajXorNaIntervalu(xorPrefiksi, i, j) * izracunajAndNaIntervalu(retkaAndTabela, i, j);
            if (p > max)
            {
                max = p;
                levo = i;
                desno = j;
            }
        }
    }

    return max;
}

int main()
{
    unsigned long n;
    scanf("%lu",&n);

    vector<unsigned long long> a, b;
    a.resize(n);
    b.resize(n);

    for (unsigned long i = 0; i < n; i++)
    {
        scanf("%llu",&a[i]);
    }

    for (unsigned long i = 0; i < n; i++)
    {
        scanf("%llu",&b[i]);
    }

    unsigned long levo, desno;
    unsigned long long max = dvaNiza(a, b, levo, desno);
    printf("%llu",max);

    return 0;
}